(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["js/finance/fee/allocation/create~js/finance/fee/allocation/edit"],{

/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/views/finance/fee/allocation/form.vue?vue&type=script&lang=js&":
/*!*********************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/views/finance/fee/allocation/form.vue?vue&type=script&lang=js& ***!
  \*********************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ __webpack_exports__["default"] = ({
  components: {},
  props: ['uuid', 'ruuid'],
  data: function data() {
    return {
      batches: [],
      fee_groups: [],
      fee_heads: [],
      transport_fees: [],
      late_fee_frequencies: [],
      selected_batch: null,
      feeAllocationForm: new Form({
        is_course_fee: false,
        batch_id: '',
        fee_groups: []
      }),
      fee_allocation: null
    };
  },
  mounted: function mounted() {
    this.getPreRequisite();
  },
  methods: {
    getPreRequisite: function getPreRequisite() {
      var _this = this;

      var loader = this.$loading.show();
      axios.get('/api/fee/allocation/pre-requisite').then(function (response) {
        _this.batches = response.batches;
        _this.fee_groups = response.fee_groups;
        _this.fee_heads = response.fee_heads;
        _this.transport_fees = response.transport_fees;
        _this.late_fee_frequencies = response.late_fee_frequencies;

        _this.fee_groups.forEach(function (fee_group) {
          _this.feeAllocationForm.fee_groups.push({
            fee_group_id: fee_group.id,
            fee_group_name: fee_group.name,
            has_transport: fee_group.options ? fee_group.options.has_transport : 0,
            installments: []
          });

          if (!_this.uuid && !_this.ruuid) _this.addInstallment(fee_group.id);
        });

        if (_this.uuid || _this.ruuid) _this.getFeeAllocation();
        loader.hide();
      })["catch"](function (error) {
        loader.hide();
        helper.showErrorMsg(error);
      });
    },
    addInstallment: function addInstallment(fee_group_id) {
      var fee_group = this.feeAllocationForm.fee_groups.find(function (o) {
        return o.fee_group_id == fee_group_id;
      });
      var heads = this.addFeeHead(fee_group_id);
      fee_group.installments.push({
        uuid: this.$uuid.v4(),
        due_date: '',
        title: '',
        fee_heads: heads,
        late_fee_applicable: false,
        late_fee_frequency: '1',
        late_fee: '',
        selected_transport_fee: null,
        transport_fee_id: ''
      });
    },
    addFeeHead: function addFeeHead(fee_group_id) {
      var heads = [];
      this.fee_heads.forEach(function (fee_head) {
        if (fee_head.fee_group_id == fee_group_id) heads.push({
          id: fee_head.id,
          amount: '',
          name: fee_head.name,
          is_optional: false
        });
      });
      return heads;
    },
    confirmDeleteInstallment: function confirmDeleteInstallment(fee_group_id, index) {
      var _this2 = this;

      return function (dialog) {
        return _this2.deleteInstallment(fee_group_id, index);
      };
    },
    deleteInstallment: function deleteInstallment(fee_group_id, index) {
      var fee_group = this.feeAllocationForm.fee_groups.find(function (o) {
        return o.fee_group_id == fee_group_id;
      });
      fee_group.installments.splice(index, 1);
    },
    getTitleName: function getTitleName(fee_group_id, index) {
      return fee_group_id + '_' + index + '_title';
    },
    getDueDateName: function getDueDateName(fee_group_id, index) {
      return fee_group_id + '_' + index + '_due_date';
    },
    getFeeName: function getFeeName(fee_group_id, index, fee_id) {
      return fee_group_id + '_' + index + '_' + fee_id + '_fee';
    },
    getLateFeeFrequencyName: function getLateFeeFrequencyName(fee_group_id, index) {
      return fee_group_id + '_' + index + '_late_fee_frequency';
    },
    getLateFeeName: function getLateFeeName(fee_group_id, index) {
      return fee_group_id + '_' + index + '_late_fee';
    },
    getTransportFeeName: function getTransportFeeName(fee_group_id, index) {
      return fee_group_id + '_' + index + '_transport_fee';
    },
    getFeeAllocation: function getFeeAllocation() {
      var _this3 = this;

      var loader = this.$loading.show();
      axios.get('/api/fee/allocation/' + (this.ruuid || this.uuid)).then(function (response) {
        _this3.fee_allocation = response;

        if (response.paid_count && !_this3.ruuid) {
          toastr.error(i18n.finance.cannot_modify_fee_allocation);
          loader.hide();

          _this3.$router.push('/finance/fee/allocation');
        }

        if (!_this3.ruuid) {
          _this3.selected_batch = {
            'name': response.batch.course.name + ' ' + response.batch.name,
            'id': response.batch_id
          };
          _this3.feeAllocationForm.batch_id = response.batch_id;
        }

        _this3.feeAllocationForm.fee_groups.forEach(function (fee_group) {
          var fee_allocation_group = response.fee_allocation_groups.find(function (o) {
            return o.fee_group_id === fee_group.fee_group_id;
          });
          fee_allocation_group.fee_installments.forEach(function (installment) {
            var heads = _this3.addFeeHead(fee_group.fee_group_id);

            installment.fee_installment_details.forEach(function (fee_installment_detail) {
              var installment_detail = heads.find(function (o) {
                return o.id === fee_installment_detail.fee_head_id;
              });
              installment_detail.amount = fee_installment_detail.amount ? fee_installment_detail.amount : '';
              installment_detail.is_optional = fee_installment_detail.is_optional ? 1 : 0;
            });
            fee_group.installments.push({
              uuid: installment.uuid,
              due_date: installment.due_date,
              title: installment.title,
              fee_heads: heads,
              late_fee_applicable: installment.late_fee_applicable,
              late_fee_frequency: installment.late_fee_frequency,
              late_fee: installment.late_fee,
              transport_fee_id: installment.transport_fee_id,
              selected_transport_fee: installment.transport_fee_id ? {
                id: installment.transport_fee_id,
                name: installment.transport_fee.name
              } : null
            });
          });
        });

        loader.hide();
      })["catch"](function (error) {
        loader.hide();
        helper.showErrorMsg(error);
      });
    },
    proceed: function proceed() {
      if (this.uuid) this.update();else this.store();
    },
    store: function store() {
      var _this4 = this;

      var loader = this.$loading.show();
      this.feeAllocationForm.post('/api/fee/allocation').then(function (response) {
        toastr.success(response.message);
        loader.hide();

        _this4.$router.push('/finance/fee/allocation');
      })["catch"](function (error) {
        loader.hide();
        helper.showErrorMsg(error);
      });
    },
    update: function update() {
      var _this5 = this;

      var loader = this.$loading.show();
      this.feeAllocationForm.patch('/api/fee/allocation/' + this.uuid).then(function (response) {
        toastr.success(response.message);
        loader.hide();

        _this5.$router.push('/finance/fee/allocation');
      })["catch"](function (error) {
        loader.hide();
        helper.showErrorMsg(error);
      });
    },
    onBatchSelect: function onBatchSelect(selectedOption) {
      this.feeAllocationForm.batch_id = selectedOption.id;
    },
    onTransportFeeSelect: function onTransportFeeSelect(selectedOption, id) {
      var field_id = id.split("_");
      var fee_group_id = field_id[0];
      var index = field_id[1];
      var fee_group = this.feeAllocationForm.fee_groups.find(function (o) {
        return o.fee_group_id == fee_group_id;
      });
      var installment = fee_group.installments[index];
      installment.transport_fee_id = selectedOption.id;
    }
  }
});

/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/views/finance/fee/allocation/form.vue?vue&type=template&id=820e1cb4&":
/*!*************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/views/finance/fee/allocation/form.vue?vue&type=template&id=820e1cb4& ***!
  \*************************************************************************************************************************************************************************************************************************/
/*! exports provided: render, staticRenderFns */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "render", function() { return render; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "staticRenderFns", function() { return staticRenderFns; });
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("div", [
    _c(
      "form",
      {
        on: {
          submit: function($event) {
            $event.preventDefault()
            return _vm.proceed($event)
          },
          keydown: function($event) {
            return _vm.feeAllocationForm.errors.clear($event.target.name)
          }
        }
      },
      [
        !_vm.uuid
          ? _c("div", { staticClass: "row" }, [
              _c("div", { staticClass: "col-12 col-sm-4" }, [
                _c(
                  "div",
                  { staticClass: "form-group" },
                  [
                    _c("label", { attrs: { for: "" } }, [
                      _vm._v(_vm._s(_vm.trans("academic.batch")))
                    ]),
                    _vm._v(" "),
                    _c(
                      "v-select",
                      {
                        attrs: {
                          label: "name",
                          "group-values": "batches",
                          "group-label": "course_group",
                          "group-select": false,
                          name: "batch_id",
                          id: "batch_id",
                          options: _vm.batches,
                          placeholder: _vm.trans("academic.select_batch")
                        },
                        on: {
                          select: _vm.onBatchSelect,
                          close: function($event) {
                            return _vm.feeAllocationForm.errors.clear(
                              "batch_id"
                            )
                          },
                          remove: function($event) {
                            _vm.feeAllocationForm.batch_id = ""
                          }
                        },
                        model: {
                          value: _vm.selected_batch,
                          callback: function($$v) {
                            _vm.selected_batch = $$v
                          },
                          expression: "selected_batch"
                        }
                      },
                      [
                        !_vm.batches.length
                          ? _c(
                              "div",
                              {
                                staticClass: "multiselect__option",
                                attrs: { slot: "afterList" },
                                slot: "afterList"
                              },
                              [
                                _vm._v(
                                  "\n                                " +
                                    _vm._s(
                                      _vm.trans("general.no_option_found")
                                    ) +
                                    "\n                            "
                                )
                              ]
                            )
                          : _vm._e()
                      ]
                    ),
                    _vm._v(" "),
                    _c("show-error", {
                      attrs: {
                        "form-name": _vm.feeAllocationForm,
                        "prop-name": "batch_id"
                      }
                    })
                  ],
                  1
                )
              ]),
              _vm._v(" "),
              !_vm.uuid
                ? _c("div", { staticClass: "col-12 col-sm-4" }, [
                    _c(
                      "div",
                      { staticClass: "form-group" },
                      [
                        _c("div", [
                          _vm._v(_vm._s(_vm.trans("finance.is_course_fee")))
                        ]),
                        _vm._v(" "),
                        _c("switches", {
                          staticClass: "m-t-20",
                          attrs: { theme: "bootstrap", color: "success" },
                          model: {
                            value: _vm.feeAllocationForm.is_course_fee,
                            callback: function($$v) {
                              _vm.$set(
                                _vm.feeAllocationForm,
                                "is_course_fee",
                                $$v
                              )
                            },
                            expression: "feeAllocationForm.is_course_fee"
                          }
                        }),
                        _vm._v(" "),
                        _c("show-error", {
                          attrs: {
                            "form-name": _vm.feeAllocationForm,
                            "prop-name": "is_course_fee"
                          }
                        })
                      ],
                      1
                    )
                  ])
                : _vm._e()
            ])
          : _vm._e(),
        _vm._v(" "),
        _vm.fee_allocation && !_vm.ruuid
          ? [
              _vm.fee_allocation.course_id
                ? _c("h4", [_vm._v(_vm._s(_vm.fee_allocation.course.name))])
                : _c("h4", { staticClass: "card-title" }, [
                    _vm._v(
                      _vm._s(
                        _vm.fee_allocation.batch.course.name +
                          " " +
                          _vm.fee_allocation.batch.name
                      )
                    )
                  ]),
              _vm._v(" "),
              _c("br")
            ]
          : _vm._e(),
        _vm._v(" "),
        _vm.feeAllocationForm.batch_id || _vm.ruuid
          ? [
              _vm._l(_vm.feeAllocationForm.fee_groups, function(fee_group) {
                return _c("div", { staticClass: "m-b-20 p-4" }, [
                  _c("h4", [_vm._v(_vm._s(fee_group.fee_group_name))]),
                  _vm._v(" "),
                  fee_group.installments.length
                    ? _c(
                        "div",
                        { staticStyle: { padding: "0px" } },
                        _vm._l(fee_group.installments, function(
                          installment,
                          index
                        ) {
                          return _c("fieldset", [
                            _c("legend", [
                              _vm._v(
                                "\n    \t                        " +
                                  _vm._s(_vm.trans("finance.fee_installment")) +
                                  " - " +
                                  _vm._s(index + 1) +
                                  " \n    \t                        "
                              ),
                              _c(
                                "span",
                                {
                                  directives: [
                                    {
                                      name: "confirm",
                                      rawName: "v-confirm",
                                      value: {
                                        ok: _vm.confirmDeleteInstallment(
                                          fee_group.fee_group_id,
                                          index
                                        )
                                      },
                                      expression:
                                        "{ok: confirmDeleteInstallment(fee_group.fee_group_id,index)}"
                                    },
                                    {
                                      name: "tooltip",
                                      rawName: "v-tooltip",
                                      value: _vm.trans(
                                        "finance.delete_fee_installment"
                                      ),
                                      expression:
                                        "trans('finance.delete_fee_installment')"
                                    }
                                  ],
                                  key: fee_group.fee_group_id + "_" + index,
                                  staticClass: "has-error m-l-10 ",
                                  staticStyle: { cursor: "pointer" }
                                },
                                [_c("i", { staticClass: "fa fa-times-circle" })]
                              )
                            ]),
                            _vm._v(" "),
                            _c(
                              "div",
                              {
                                staticClass: "row",
                                staticStyle: { padding: "0 20px" }
                              },
                              [
                                _c("div", { staticClass: "col-12 col-sm-6" }, [
                                  _c("div", { staticClass: "row" }, [
                                    _c(
                                      "div",
                                      { staticClass: "col-12 col-sm-6" },
                                      [
                                        _c(
                                          "div",
                                          { staticClass: "form-group" },
                                          [
                                            _c(
                                              "label",
                                              { attrs: { for: "" } },
                                              [
                                                _vm._v(
                                                  _vm._s(
                                                    _vm.trans(
                                                      "finance.fee_installment_title"
                                                    )
                                                  )
                                                )
                                              ]
                                            ),
                                            _vm._v(" "),
                                            _c("input", {
                                              directives: [
                                                {
                                                  name: "model",
                                                  rawName: "v-model",
                                                  value: installment.title,
                                                  expression:
                                                    "installment.title"
                                                }
                                              ],
                                              staticClass: "form-control",
                                              attrs: {
                                                type: "text",
                                                name: _vm.getTitleName(
                                                  fee_group.fee_group_id,
                                                  index
                                                ),
                                                placeholder: _vm.trans(
                                                  "finance.fee_installment_title"
                                                )
                                              },
                                              domProps: {
                                                value: installment.title
                                              },
                                              on: {
                                                input: function($event) {
                                                  if ($event.target.composing) {
                                                    return
                                                  }
                                                  _vm.$set(
                                                    installment,
                                                    "title",
                                                    $event.target.value
                                                  )
                                                }
                                              }
                                            }),
                                            _vm._v(" "),
                                            _c("show-error", {
                                              attrs: {
                                                "form-name":
                                                  _vm.feeAllocationForm,
                                                "prop-name": _vm.getTitleName(
                                                  fee_group.fee_group_id,
                                                  index
                                                )
                                              }
                                            })
                                          ],
                                          1
                                        )
                                      ]
                                    ),
                                    _vm._v(" "),
                                    _c(
                                      "div",
                                      { staticClass: "col-12 col-sm-6" },
                                      [
                                        _c(
                                          "div",
                                          { staticClass: "form-group" },
                                          [
                                            _c(
                                              "label",
                                              { attrs: { for: "" } },
                                              [
                                                _vm._v(
                                                  _vm._s(
                                                    _vm.trans(
                                                      "finance.fee_installment_due_date"
                                                    )
                                                  )
                                                )
                                              ]
                                            ),
                                            _vm._v(" "),
                                            _c("datepicker", {
                                              attrs: {
                                                bootstrapStyling: true,
                                                placeholder: _vm.trans(
                                                  "finance.fee_installment_due_date"
                                                ),
                                                name: _vm.getDueDateName(
                                                  fee_group.fee_group_id,
                                                  index
                                                )
                                              },
                                              on: {
                                                selected: function($event) {
                                                  _vm.feeAllocationForm.errors.clear(
                                                    _vm.getDueDateName(
                                                      fee_group.fee_group_id,
                                                      index
                                                    )
                                                  )
                                                }
                                              },
                                              model: {
                                                value: installment.due_date,
                                                callback: function($$v) {
                                                  _vm.$set(
                                                    installment,
                                                    "due_date",
                                                    $$v
                                                  )
                                                },
                                                expression:
                                                  "installment.due_date"
                                              }
                                            }),
                                            _vm._v(" "),
                                            _c("show-error", {
                                              attrs: {
                                                "form-name":
                                                  _vm.feeAllocationForm,
                                                "prop-name": _vm.getDueDateName(
                                                  fee_group.fee_group_id,
                                                  index
                                                )
                                              }
                                            })
                                          ],
                                          1
                                        )
                                      ]
                                    ),
                                    _vm._v(" "),
                                    _c(
                                      "div",
                                      { staticClass: "col-12 col-sm-4" },
                                      [
                                        _c(
                                          "div",
                                          { staticClass: "form-group" },
                                          [
                                            _c(
                                              "label",
                                              { attrs: { for: "" } },
                                              [
                                                _vm._v(
                                                  _vm._s(
                                                    _vm.trans(
                                                      "finance.late_fee_applicable"
                                                    )
                                                  )
                                                )
                                              ]
                                            ),
                                            _vm._v(" "),
                                            _c("br"),
                                            _vm._v(" "),
                                            _c("switches", {
                                              staticClass: "m-l-20",
                                              attrs: {
                                                theme: "bootstrap",
                                                color: "success"
                                              },
                                              model: {
                                                value:
                                                  installment.late_fee_applicable,
                                                callback: function($$v) {
                                                  _vm.$set(
                                                    installment,
                                                    "late_fee_applicable",
                                                    $$v
                                                  )
                                                },
                                                expression:
                                                  "installment.late_fee_applicable"
                                              }
                                            })
                                          ],
                                          1
                                        )
                                      ]
                                    ),
                                    _vm._v(" "),
                                    installment.late_fee_applicable
                                      ? _c(
                                          "div",
                                          { staticClass: "col-12 col-sm-4" },
                                          [
                                            _c(
                                              "div",
                                              { staticClass: "form-group" },
                                              [
                                                _c(
                                                  "label",
                                                  { attrs: { for: "" } },
                                                  [
                                                    _vm._v(
                                                      _vm._s(
                                                        _vm.trans(
                                                          "finance.late_fee_frequency"
                                                        )
                                                      )
                                                    )
                                                  ]
                                                ),
                                                _vm._v(" "),
                                                _c(
                                                  "select",
                                                  {
                                                    directives: [
                                                      {
                                                        name: "model",
                                                        rawName: "v-model",
                                                        value:
                                                          installment.late_fee_frequency,
                                                        expression:
                                                          "installment.late_fee_frequency"
                                                      }
                                                    ],
                                                    staticClass:
                                                      "custom-select col-12",
                                                    attrs: {
                                                      name: _vm.getLateFeeFrequencyName(
                                                        fee_group.fee_group_id,
                                                        index
                                                      )
                                                    },
                                                    on: {
                                                      change: function($event) {
                                                        var $$selectedVal = Array.prototype.filter
                                                          .call(
                                                            $event.target
                                                              .options,
                                                            function(o) {
                                                              return o.selected
                                                            }
                                                          )
                                                          .map(function(o) {
                                                            var val =
                                                              "_value" in o
                                                                ? o._value
                                                                : o.value
                                                            return val
                                                          })
                                                        _vm.$set(
                                                          installment,
                                                          "late_fee_frequency",
                                                          $event.target.multiple
                                                            ? $$selectedVal
                                                            : $$selectedVal[0]
                                                        )
                                                      }
                                                    }
                                                  },
                                                  _vm._l(
                                                    _vm.late_fee_frequencies,
                                                    function(option) {
                                                      return _c(
                                                        "option",
                                                        {
                                                          domProps: {
                                                            value: option.value
                                                          }
                                                        },
                                                        [
                                                          _vm._v(
                                                            "\n                                                    " +
                                                              _vm._s(
                                                                option.text
                                                              ) +
                                                              "\n                                                  "
                                                          )
                                                        ]
                                                      )
                                                    }
                                                  ),
                                                  0
                                                ),
                                                _vm._v(" "),
                                                _c("show-error", {
                                                  attrs: {
                                                    "form-name":
                                                      _vm.feeAllocationForm,
                                                    "prop-name": _vm.getLateFeeFrequencyName(
                                                      fee_group.fee_group_id,
                                                      index
                                                    )
                                                  }
                                                })
                                              ],
                                              1
                                            )
                                          ]
                                        )
                                      : _vm._e(),
                                    _vm._v(" "),
                                    installment.late_fee_applicable
                                      ? _c(
                                          "div",
                                          { staticClass: "col-12 col-sm-4" },
                                          [
                                            _c(
                                              "div",
                                              { staticClass: "form-group" },
                                              [
                                                _c(
                                                  "label",
                                                  { attrs: { for: "" } },
                                                  [
                                                    _vm._v(
                                                      _vm._s(
                                                        _vm.trans(
                                                          "finance.late_fee"
                                                        )
                                                      )
                                                    )
                                                  ]
                                                ),
                                                _vm._v(" "),
                                                _c("input", {
                                                  directives: [
                                                    {
                                                      name: "model",
                                                      rawName: "v-model",
                                                      value:
                                                        installment.late_fee,
                                                      expression:
                                                        "installment.late_fee"
                                                    }
                                                  ],
                                                  staticClass: "form-control",
                                                  attrs: {
                                                    type: "text",
                                                    name: _vm.getLateFeeName(
                                                      fee_group.fee_group_id,
                                                      index
                                                    ),
                                                    placeholder: _vm.trans(
                                                      "finance.late_fee"
                                                    )
                                                  },
                                                  domProps: {
                                                    value: installment.late_fee
                                                  },
                                                  on: {
                                                    input: function($event) {
                                                      if (
                                                        $event.target.composing
                                                      ) {
                                                        return
                                                      }
                                                      _vm.$set(
                                                        installment,
                                                        "late_fee",
                                                        $event.target.value
                                                      )
                                                    }
                                                  }
                                                }),
                                                _vm._v(" "),
                                                _c("show-error", {
                                                  attrs: {
                                                    "form-name":
                                                      _vm.feeAllocationForm,
                                                    "prop-name": _vm.getLateFeeName(
                                                      fee_group.fee_group_id,
                                                      index
                                                    )
                                                  }
                                                })
                                              ],
                                              1
                                            )
                                          ]
                                        )
                                      : _vm._e()
                                  ])
                                ]),
                                _vm._v(" "),
                                _c("div", { staticClass: "col-12 col-sm-6" }, [
                                  _c(
                                    "div",
                                    { staticClass: "row" },
                                    [
                                      _vm._l(installment.fee_heads, function(
                                        fee_head
                                      ) {
                                        return _c(
                                          "div",
                                          { staticClass: "col-12 col-sm-6" },
                                          [
                                            _c(
                                              "div",
                                              { staticClass: "form-group" },
                                              [
                                                _c(
                                                  "label",
                                                  { attrs: { for: "" } },
                                                  [
                                                    _vm._v(
                                                      _vm._s(fee_head.name)
                                                    )
                                                  ]
                                                ),
                                                _vm._v(" "),
                                                _c(
                                                  "div",
                                                  {
                                                    staticClass:
                                                      "input-group mb-3"
                                                  },
                                                  [
                                                    _c("input", {
                                                      directives: [
                                                        {
                                                          name: "model",
                                                          rawName: "v-model",
                                                          value:
                                                            fee_head.amount,
                                                          expression:
                                                            "fee_head.amount"
                                                        }
                                                      ],
                                                      staticClass:
                                                        "form-control",
                                                      attrs: {
                                                        type: "text",
                                                        name: _vm.getFeeName(
                                                          fee_group.fee_group_id,
                                                          index,
                                                          fee_head.id
                                                        ),
                                                        placeholder: _vm.trans(
                                                          "finance.fee_installment_amount"
                                                        )
                                                      },
                                                      domProps: {
                                                        value: fee_head.amount
                                                      },
                                                      on: {
                                                        input: function(
                                                          $event
                                                        ) {
                                                          if (
                                                            $event.target
                                                              .composing
                                                          ) {
                                                            return
                                                          }
                                                          _vm.$set(
                                                            fee_head,
                                                            "amount",
                                                            $event.target.value
                                                          )
                                                        }
                                                      }
                                                    }),
                                                    _vm._v(" "),
                                                    _c(
                                                      "div",
                                                      {
                                                        staticClass:
                                                          "input-group-append"
                                                      },
                                                      [
                                                        _c(
                                                          "div",
                                                          {
                                                            staticClass:
                                                              "input-group-text"
                                                          },
                                                          [
                                                            _c("input", {
                                                              directives: [
                                                                {
                                                                  name: "model",
                                                                  rawName:
                                                                    "v-model",
                                                                  value:
                                                                    fee_head.is_optional,
                                                                  expression:
                                                                    "fee_head.is_optional"
                                                                },
                                                                {
                                                                  name:
                                                                    "tooltip",
                                                                  rawName:
                                                                    "v-tooltip",
                                                                  value: _vm.trans(
                                                                    "finance.fee_is_optional"
                                                                  ),
                                                                  expression:
                                                                    "trans('finance.fee_is_optional')"
                                                                }
                                                              ],
                                                              attrs: {
                                                                type: "checkbox"
                                                              },
                                                              domProps: {
                                                                checked: Array.isArray(
                                                                  fee_head.is_optional
                                                                )
                                                                  ? _vm._i(
                                                                      fee_head.is_optional,
                                                                      null
                                                                    ) > -1
                                                                  : fee_head.is_optional
                                                              },
                                                              on: {
                                                                change: function(
                                                                  $event
                                                                ) {
                                                                  var $$a =
                                                                      fee_head.is_optional,
                                                                    $$el =
                                                                      $event.target,
                                                                    $$c = $$el.checked
                                                                      ? true
                                                                      : false
                                                                  if (
                                                                    Array.isArray(
                                                                      $$a
                                                                    )
                                                                  ) {
                                                                    var $$v = null,
                                                                      $$i = _vm._i(
                                                                        $$a,
                                                                        $$v
                                                                      )
                                                                    if (
                                                                      $$el.checked
                                                                    ) {
                                                                      $$i < 0 &&
                                                                        _vm.$set(
                                                                          fee_head,
                                                                          "is_optional",
                                                                          $$a.concat(
                                                                            [
                                                                              $$v
                                                                            ]
                                                                          )
                                                                        )
                                                                    } else {
                                                                      $$i >
                                                                        -1 &&
                                                                        _vm.$set(
                                                                          fee_head,
                                                                          "is_optional",
                                                                          $$a
                                                                            .slice(
                                                                              0,
                                                                              $$i
                                                                            )
                                                                            .concat(
                                                                              $$a.slice(
                                                                                $$i +
                                                                                  1
                                                                              )
                                                                            )
                                                                        )
                                                                    }
                                                                  } else {
                                                                    _vm.$set(
                                                                      fee_head,
                                                                      "is_optional",
                                                                      $$c
                                                                    )
                                                                  }
                                                                }
                                                              }
                                                            })
                                                          ]
                                                        )
                                                      ]
                                                    )
                                                  ]
                                                ),
                                                _vm._v(" "),
                                                _c("show-error", {
                                                  attrs: {
                                                    "form-name":
                                                      _vm.feeAllocationForm,
                                                    "prop-name": _vm.getFeeName(
                                                      fee_group.fee_group_id,
                                                      index,
                                                      fee_head.id
                                                    )
                                                  }
                                                })
                                              ],
                                              1
                                            )
                                          ]
                                        )
                                      }),
                                      _vm._v(" "),
                                      fee_group.has_transport
                                        ? _c(
                                            "div",
                                            { staticClass: "col-12 col-sm-6" },
                                            [
                                              _c(
                                                "div",
                                                { staticClass: "form-group" },
                                                [
                                                  _c(
                                                    "label",
                                                    { attrs: { for: "" } },
                                                    [
                                                      _vm._v(
                                                        _vm._s(
                                                          _vm.trans(
                                                            "transport.transport"
                                                          )
                                                        )
                                                      )
                                                    ]
                                                  ),
                                                  _vm._v(" "),
                                                  _c(
                                                    "v-select",
                                                    {
                                                      attrs: {
                                                        label: "name",
                                                        name: _vm.getTransportFeeName(
                                                          fee_group.fee_group_id,
                                                          index
                                                        ),
                                                        id: _vm.getTransportFeeName(
                                                          fee_group.fee_group_id,
                                                          index
                                                        ),
                                                        options:
                                                          _vm.transport_fees,
                                                        placeholder: _vm.trans(
                                                          "general.select_one"
                                                        )
                                                      },
                                                      on: {
                                                        select:
                                                          _vm.onTransportFeeSelect,
                                                        close: function(
                                                          $event
                                                        ) {},
                                                        remove: function(
                                                          $event
                                                        ) {
                                                          installment.transport_fee_id =
                                                            ""
                                                        }
                                                      },
                                                      model: {
                                                        value:
                                                          installment.selected_transport_fee,
                                                        callback: function(
                                                          $$v
                                                        ) {
                                                          _vm.$set(
                                                            installment,
                                                            "selected_transport_fee",
                                                            $$v
                                                          )
                                                        },
                                                        expression:
                                                          "installment.selected_transport_fee"
                                                      }
                                                    },
                                                    [
                                                      !_vm.transport_fees.length
                                                        ? _c(
                                                            "div",
                                                            {
                                                              staticClass:
                                                                "multiselect__option",
                                                              attrs: {
                                                                slot:
                                                                  "afterList"
                                                              },
                                                              slot: "afterList"
                                                            },
                                                            [
                                                              _vm._v(
                                                                "\n                                                        " +
                                                                  _vm._s(
                                                                    _vm.trans(
                                                                      "general.no_option_found"
                                                                    )
                                                                  ) +
                                                                  "\n                                                    "
                                                              )
                                                            ]
                                                          )
                                                        : _vm._e()
                                                    ]
                                                  ),
                                                  _vm._v(" "),
                                                  _c("show-error", {
                                                    attrs: {
                                                      "form-name":
                                                        _vm.feeAllocationForm,
                                                      "prop-name": _vm.getTransportFeeName(
                                                        fee_group.fee_group_id,
                                                        index
                                                      )
                                                    }
                                                  })
                                                ],
                                                1
                                              )
                                            ]
                                          )
                                        : _vm._e()
                                    ],
                                    2
                                  )
                                ])
                              ]
                            )
                          ])
                        }),
                        0
                      )
                    : _vm._e(),
                  _vm._v(" "),
                  _c(
                    "button",
                    {
                      staticClass: "btn btn-info btn-sm pull-right",
                      attrs: { type: "button" },
                      on: {
                        click: function($event) {
                          return _vm.addInstallment(fee_group.fee_group_id)
                        }
                      }
                    },
                    [_vm._v(_vm._s(_vm.trans("finance.add_fee_installment")))]
                  ),
                  _vm._v(" "),
                  _c("div", { staticClass: "clearfix" })
                ])
              }),
              _vm._v(" "),
              _c(
                "div",
                { staticClass: "card-footer text-right" },
                [
                  _c(
                    "router-link",
                    {
                      directives: [
                        {
                          name: "show",
                          rawName: "v-show",
                          value: _vm.uuid,
                          expression: "uuid"
                        }
                      ],
                      staticClass: "btn btn-danger waves-effect waves-light ",
                      attrs: { to: "/finance/fee/allocation" }
                    },
                    [_vm._v(_vm._s(_vm.trans("general.cancel")))]
                  ),
                  _vm._v(" "),
                  _c(
                    "button",
                    {
                      staticClass: "btn btn-info waves-effect waves-light",
                      attrs: { type: "submit" }
                    },
                    [_vm._v(_vm._s(_vm.trans("general.save")))]
                  )
                ],
                1
              )
            ]
          : _vm._e()
      ],
      2
    )
  ])
}
var staticRenderFns = []
render._withStripped = true



/***/ }),

/***/ "./resources/js/views/finance/fee/allocation/form.vue":
/*!************************************************************!*\
  !*** ./resources/js/views/finance/fee/allocation/form.vue ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _form_vue_vue_type_template_id_820e1cb4___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./form.vue?vue&type=template&id=820e1cb4& */ "./resources/js/views/finance/fee/allocation/form.vue?vue&type=template&id=820e1cb4&");
/* harmony import */ var _form_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form.vue?vue&type=script&lang=js& */ "./resources/js/views/finance/fee/allocation/form.vue?vue&type=script&lang=js&");
/* empty/unused harmony star reexport *//* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  _form_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _form_vue_vue_type_template_id_820e1cb4___WEBPACK_IMPORTED_MODULE_0__["render"],
  _form_vue_vue_type_template_id_820e1cb4___WEBPACK_IMPORTED_MODULE_0__["staticRenderFns"],
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/js/views/finance/fee/allocation/form.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/js/views/finance/fee/allocation/form.vue?vue&type=script&lang=js&":
/*!*************************************************************************************!*\
  !*** ./resources/js/views/finance/fee/allocation/form.vue?vue&type=script&lang=js& ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_ref_4_0_node_modules_vue_loader_lib_index_js_vue_loader_options_form_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib??ref--4-0!../../../../../../node_modules/vue-loader/lib??vue-loader-options!./form.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/views/finance/fee/allocation/form.vue?vue&type=script&lang=js&");
/* empty/unused harmony star reexport */ /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_ref_4_0_node_modules_vue_loader_lib_index_js_vue_loader_options_form_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/js/views/finance/fee/allocation/form.vue?vue&type=template&id=820e1cb4&":
/*!*******************************************************************************************!*\
  !*** ./resources/js/views/finance/fee/allocation/form.vue?vue&type=template&id=820e1cb4& ***!
  \*******************************************************************************************/
/*! exports provided: render, staticRenderFns */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_form_vue_vue_type_template_id_820e1cb4___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!../../../../../../node_modules/vue-loader/lib??vue-loader-options!./form.vue?vue&type=template&id=820e1cb4& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/views/finance/fee/allocation/form.vue?vue&type=template&id=820e1cb4&");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "render", function() { return _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_form_vue_vue_type_template_id_820e1cb4___WEBPACK_IMPORTED_MODULE_0__["render"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "staticRenderFns", function() { return _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_form_vue_vue_type_template_id_820e1cb4___WEBPACK_IMPORTED_MODULE_0__["staticRenderFns"]; });



/***/ })

}]);
//# sourceMappingURL=edit.js.map?id=d1795d8806f66341186d