(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["js/finance/transaction/expense/edit~js/finance/transaction/expense/index"],{

/***/ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/views/finance/transaction/expense/form.vue?vue&type=script&lang=js&":
/*!**************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib??ref--4-0!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/views/finance/transaction/expense/form.vue?vue&type=script&lang=js& ***!
  \**************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _configuration_finance_transaction_category_form__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../configuration/finance/transaction/category/form */ "./resources/js/views/configuration/finance/transaction/category/form.vue");
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ __webpack_exports__["default"] = ({
  components: {
    transactionCategoryForm: _configuration_finance_transaction_category_form__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  data: function data() {
    return {
      expenseForm: new Form({
        transaction_category_id: '',
        account_id: '',
        payment_method_id: '',
        instrument_number: '',
        instrument_date: '',
        instrument_clearing_date: '',
        instrument_bank_detail: '',
        reference_number: '',
        amount: '',
        date_of_expense: '',
        description: '',
        upload_token: ''
      }),
      transaction_categories: [],
      selected_transaction_category: null,
      accounts: [],
      selected_account: null,
      payment_methods: [],
      selected_payment_method: null,
      payment_method_details: [],
      payment_method_detail: {},
      module_id: '',
      clearAttachment: true,
      showTransactionCategoryModal: false,
      default_currency: helper.getConfig('default_currency')
    };
  },
  props: ['uuid'],
  mounted: function mounted() {
    if (!helper.hasPermission('create-expense') && !helper.hasPermission('edit-expense')) {
      helper.notAccessibleMsg();
      this.$router.push('/dashboard');
    }

    if (this.uuid) this.get();else this.expenseForm.upload_token = this.$uuid.v4();
    this.getPreRequisite();
  },
  methods: {
    hasPermission: function hasPermission(permission) {
      return helper.hasPermission(permission);
    },
    getPreRequisite: function getPreRequisite() {
      var _this = this;

      var loader = this.$loading.show();
      this.showTransactionCategoryModal = false;
      axios.get('/api/expense/pre-requisite').then(function (response) {
        _this.transaction_categories = response.transaction_categories;
        _this.accounts = response.accounts;
        _this.payment_methods = response.payment_methods;
        _this.payment_method_details = response.payment_method_details;
        loader.hide();
      })["catch"](function (error) {
        loader.hide();
        helper.showErrorMsg(error);
      });
    },
    proceed: function proceed() {
      if (this.uuid) this.update();else this.store();
    },
    store: function store() {
      var _this2 = this;

      var loader = this.$loading.show();
      this.expenseForm.post('/api/expense').then(function (response) {
        toastr.success(response.message);
        _this2.clearAttachment = !_this2.clearAttachment;
        _this2.expenseForm.upload_token = _this2.$uuid.v4();
        _this2.selected_transaction_category = null;
        _this2.selected_account = null;
        _this2.selected_payment_method = null;
        _this2.payment_method_detail = null;

        _this2.$emit('completed');

        loader.hide();
      })["catch"](function (error) {
        loader.hide();
        helper.showErrorMsg(error);
      });
    },
    get: function get() {
      var _this3 = this;

      var loader = this.$loading.show();
      axios.get('/api/expense/' + this.uuid).then(function (response) {
        _this3.expenseForm.amount = _this3.formatNumber(response.expense.amount);
        _this3.expenseForm.date_of_expense = response.expense.date_of_expense;
        _this3.expenseForm.description = response.expense.description;
        _this3.expenseForm.transaction_category_id = response.expense.transaction_category_id;
        _this3.selected_transaction_category = response.expense.transaction_category_id ? {
          id: response.expense.transaction_category_id,
          name: response.expense.transaction_category.name
        } : null;
        _this3.expenseForm.account_id = response.expense.transaction.account_id;
        _this3.selected_account = response.expense.transaction.account_id ? {
          id: response.expense.transaction.account_id,
          name: response.expense.transaction.account.name
        } : null;
        _this3.expenseForm.payment_method_id = response.expense.transaction.payment_method_id;
        _this3.selected_payment_method = response.expense.transaction.payment_method_id ? {
          id: response.expense.transaction.payment_method_id,
          name: response.expense.transaction.payment_method.name
        } : null;
        _this3.expenseForm.instrument_number = response.expense.transaction.instrument_number;
        _this3.expenseForm.instrument_date = response.expense.transaction.instrument_date;
        _this3.expenseForm.instrument_clearing_date = response.expense.transaction.instrument_clearing_date;
        _this3.expenseForm.instrument_bank_detail = response.expense.transaction.instrument_bank_detail;
        _this3.expenseForm.reference_number = response.expense.transaction.reference_number;
        _this3.expenseForm.upload_token = response.expense.upload_token;
        _this3.module_id = response.expense.id;
        loader.hide();
      })["catch"](function (error) {
        loader.hide();
        helper.showErrorMsg(error);

        _this3.$router.push('/finance/transaction/expense');
      });
    },
    update: function update() {
      var _this4 = this;

      var loader = this.$loading.show();
      this.expenseForm.patch('/api/expense/' + this.uuid).then(function (response) {
        toastr.success(response.message);
        loader.hide();

        _this4.$router.push('/finance/transaction/expense');
      })["catch"](function (error) {
        loader.hide();
        helper.showErrorMsg(error);
      });
    },
    onTransactionCategorySelect: function onTransactionCategorySelect(selectedOption) {
      this.expenseForm.transaction_category_id = selectedOption.id;
    },
    onAccountSelect: function onAccountSelect(selectedOption) {
      this.expenseForm.account_id = selectedOption.id;
    },
    onPaymentMethodSelect: function onPaymentMethodSelect(selectedOption) {
      this.expenseForm.payment_method_id = selectedOption.id;
      this.payment_method_detail = this.payment_method_details.find(function (o) {
        return o.id == selectedOption.id;
      });
    },
    formatCurrency: function formatCurrency(price) {
      return helper.formatCurrency(price);
    },
    formatNumber: function formatNumber(number) {
      return helper.formatNumber(number, this.default_currency.decimal_place);
    },
    getPaymentMethodDetail: function getPaymentMethodDetail(field) {
      return helper.getPaymentMethodDetail(this.payment_method_detail, field);
    }
  }
});

/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/views/finance/transaction/expense/form.vue?vue&type=template&id=bd3aba80&":
/*!******************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./resources/js/views/finance/transaction/expense/form.vue?vue&type=template&id=bd3aba80& ***!
  \******************************************************************************************************************************************************************************************************************************/
/*! exports provided: render, staticRenderFns */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "render", function() { return render; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "staticRenderFns", function() { return staticRenderFns; });
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "div",
    [
      _c(
        "form",
        {
          on: {
            submit: function($event) {
              $event.preventDefault()
              return _vm.proceed($event)
            },
            keydown: function($event) {
              return _vm.expenseForm.errors.clear($event.target.name)
            }
          }
        },
        [
          _c("div", { staticClass: "row" }, [
            _c("div", { staticClass: "col-12 col-sm-3" }, [
              _c(
                "div",
                { staticClass: "form-group" },
                [
                  _c("label", { attrs: { for: "" } }, [
                    _vm._v(
                      _vm._s(_vm.trans("finance.transaction_category")) + " "
                    )
                  ]),
                  _vm._v(" "),
                  _vm.hasPermission("access-configuration")
                    ? _c(
                        "button",
                        {
                          staticClass: "btn btn-xs btn-info pull-right",
                          attrs: { type: "button" },
                          on: {
                            click: function($event) {
                              _vm.showTransactionCategoryModal = true
                            }
                          }
                        },
                        [_vm._v(_vm._s(_vm.trans("general.add_new")))]
                      )
                    : _vm._e(),
                  _vm._v(" "),
                  _c(
                    "v-select",
                    {
                      attrs: {
                        label: "name",
                        name: "transaction_category_id",
                        id: "transaction_category_id",
                        options: _vm.transaction_categories,
                        placeholder: _vm.trans(
                          "finance.select_transaction_category"
                        )
                      },
                      on: {
                        select: _vm.onTransactionCategorySelect,
                        close: function($event) {
                          return _vm.expenseForm.errors.clear(
                            "transaction_category_id"
                          )
                        },
                        remove: function($event) {
                          _vm.expenseForm.transaction_category_id = ""
                        }
                      },
                      model: {
                        value: _vm.selected_transaction_category,
                        callback: function($$v) {
                          _vm.selected_transaction_category = $$v
                        },
                        expression: "selected_transaction_category"
                      }
                    },
                    [
                      !_vm.transaction_categories.length
                        ? _c(
                            "div",
                            {
                              staticClass: "multiselect__option",
                              attrs: { slot: "afterList" },
                              slot: "afterList"
                            },
                            [
                              _vm._v(
                                "\n                                " +
                                  _vm._s(_vm.trans("general.no_option_found")) +
                                  "\n                            "
                              )
                            ]
                          )
                        : _vm._e()
                    ]
                  ),
                  _vm._v(" "),
                  _c("show-error", {
                    attrs: {
                      "form-name": _vm.expenseForm,
                      "prop-name": "transaction_category_id"
                    }
                  })
                ],
                1
              )
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "col-12 col-sm-3" }, [
              _c(
                "div",
                { staticClass: "form-group" },
                [
                  _c("label", { attrs: { for: "" } }, [
                    _vm._v(_vm._s(_vm.trans("finance.account")) + " ")
                  ]),
                  _vm._v(" "),
                  _c(
                    "v-select",
                    {
                      attrs: {
                        label: "name",
                        name: "account_id",
                        id: "account_id",
                        options: _vm.accounts,
                        placeholder: _vm.trans("finance.select_account"),
                        disabled: _vm.uuid ? true : false
                      },
                      on: {
                        select: _vm.onAccountSelect,
                        close: function($event) {
                          return _vm.expenseForm.errors.clear("account_id")
                        },
                        remove: function($event) {
                          _vm.expenseForm.account_id = ""
                        }
                      },
                      model: {
                        value: _vm.selected_account,
                        callback: function($$v) {
                          _vm.selected_account = $$v
                        },
                        expression: "selected_account"
                      }
                    },
                    [
                      !_vm.accounts.length
                        ? _c(
                            "div",
                            {
                              staticClass: "multiselect__option",
                              attrs: { slot: "afterList" },
                              slot: "afterList"
                            },
                            [
                              _vm._v(
                                "\n                                " +
                                  _vm._s(_vm.trans("general.no_option_found")) +
                                  "\n                            "
                              )
                            ]
                          )
                        : _vm._e()
                    ]
                  ),
                  _vm._v(" "),
                  _c("show-error", {
                    attrs: {
                      "form-name": _vm.expenseForm,
                      "prop-name": "account_id"
                    }
                  })
                ],
                1
              )
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "col-12 col-sm-3" }, [
              _c(
                "div",
                { staticClass: "form-group" },
                [
                  _c("label", { attrs: { for: "" } }, [
                    _vm._v(_vm._s(_vm.trans("finance.amount")))
                  ]),
                  _vm._v(" "),
                  _c("currency-input", {
                    attrs: {
                      position: _vm.default_currency.position,
                      symbol: _vm.default_currency.symbol,
                      name: "amount",
                      placeholder: _vm.trans("finance.amount")
                    },
                    nativeOn: {
                      input: function($event) {
                        return _vm.expenseForm.errors.clear("amount")
                      }
                    },
                    model: {
                      value: _vm.expenseForm.amount,
                      callback: function($$v) {
                        _vm.$set(_vm.expenseForm, "amount", $$v)
                      },
                      expression: "expenseForm.amount"
                    }
                  }),
                  _vm._v(" "),
                  _c("show-error", {
                    attrs: {
                      "form-name": _vm.expenseForm,
                      "prop-name": "amount"
                    }
                  })
                ],
                1
              )
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "col-12 col-sm-3" }, [
              _c(
                "div",
                { staticClass: "form-group" },
                [
                  _c("label", { attrs: { for: "" } }, [
                    _vm._v(_vm._s(_vm.trans("finance.date_of_expense")))
                  ]),
                  _vm._v(" "),
                  _c("datepicker", {
                    attrs: {
                      bootstrapStyling: true,
                      placeholder: _vm.trans("finance.date_of_expense")
                    },
                    on: {
                      selected: function($event) {
                        return _vm.expenseForm.errors.clear("date_of_expense")
                      }
                    },
                    model: {
                      value: _vm.expenseForm.date_of_expense,
                      callback: function($$v) {
                        _vm.$set(_vm.expenseForm, "date_of_expense", $$v)
                      },
                      expression: "expenseForm.date_of_expense"
                    }
                  }),
                  _vm._v(" "),
                  _c("show-error", {
                    attrs: {
                      "form-name": _vm.expenseForm,
                      "prop-name": "date_of_expense"
                    }
                  })
                ],
                1
              )
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "col-12 col-sm-3" }, [
              _c(
                "div",
                { staticClass: "form-group" },
                [
                  _c("label", { attrs: { for: "" } }, [
                    _vm._v(_vm._s(_vm.trans("finance.payment_method")) + " ")
                  ]),
                  _vm._v(" "),
                  _c(
                    "v-select",
                    {
                      attrs: {
                        label: "name",
                        name: "payment_method_id",
                        id: "payment_method_id",
                        options: _vm.payment_methods,
                        placeholder: _vm.trans("finance.select_payment_method")
                      },
                      on: {
                        select: _vm.onPaymentMethodSelect,
                        close: function($event) {
                          return _vm.expenseForm.errors.clear(
                            "payment_method_id"
                          )
                        },
                        remove: function($event) {
                          _vm.expenseForm.payment_method_id = ""
                        }
                      },
                      model: {
                        value: _vm.selected_payment_method,
                        callback: function($$v) {
                          _vm.selected_payment_method = $$v
                        },
                        expression: "selected_payment_method"
                      }
                    },
                    [
                      !_vm.payment_methods.length
                        ? _c(
                            "div",
                            {
                              staticClass: "multiselect__option",
                              attrs: { slot: "afterList" },
                              slot: "afterList"
                            },
                            [
                              _vm._v(
                                "\n                                " +
                                  _vm._s(_vm.trans("general.no_option_found")) +
                                  "\n                            "
                              )
                            ]
                          )
                        : _vm._e()
                    ]
                  ),
                  _vm._v(" "),
                  _c("show-error", {
                    attrs: {
                      "form-name": _vm.expenseForm,
                      "prop-name": "payment_method_id"
                    }
                  })
                ],
                1
              )
            ]),
            _vm._v(" "),
            _vm.getPaymentMethodDetail("instrument_number")
              ? _c("div", { staticClass: "col-12 col-sm-3" }, [
                  _c(
                    "div",
                    { staticClass: "form-group" },
                    [
                      _c("label", { attrs: { for: "" } }, [
                        _vm._v(_vm._s(_vm.trans("finance.instrument_number")))
                      ]),
                      _vm._v(" "),
                      _c("input", {
                        directives: [
                          {
                            name: "model",
                            rawName: "v-model",
                            value: _vm.expenseForm.instrument_number,
                            expression: "expenseForm.instrument_number"
                          }
                        ],
                        staticClass: "form-control",
                        attrs: {
                          type: "text",
                          name: "instrument_number",
                          placeholder: _vm.trans("finance.instrument_number")
                        },
                        domProps: { value: _vm.expenseForm.instrument_number },
                        on: {
                          input: function($event) {
                            if ($event.target.composing) {
                              return
                            }
                            _vm.$set(
                              _vm.expenseForm,
                              "instrument_number",
                              $event.target.value
                            )
                          }
                        }
                      }),
                      _vm._v(" "),
                      _c("show-error", {
                        attrs: {
                          "form-name": _vm.expenseForm,
                          "prop-name": "instrument_number"
                        }
                      })
                    ],
                    1
                  )
                ])
              : _vm._e(),
            _vm._v(" "),
            _vm.getPaymentMethodDetail("instrument_date")
              ? _c("div", { staticClass: "col-12 col-sm-3" }, [
                  _c(
                    "div",
                    { staticClass: "form-group" },
                    [
                      _c("label", { attrs: { for: "" } }, [
                        _vm._v(_vm._s(_vm.trans("finance.instrument_date")))
                      ]),
                      _vm._v(" "),
                      _c("datepicker", {
                        attrs: {
                          bootstrapStyling: true,
                          placeholder: _vm.trans("finance.instrument_date")
                        },
                        on: {
                          selected: function($event) {
                            return _vm.expenseForm.errors.clear(
                              "instrument_date"
                            )
                          }
                        },
                        model: {
                          value: _vm.expenseForm.instrument_date,
                          callback: function($$v) {
                            _vm.$set(_vm.expenseForm, "instrument_date", $$v)
                          },
                          expression: "expenseForm.instrument_date"
                        }
                      }),
                      _vm._v(" "),
                      _c("show-error", {
                        attrs: {
                          "form-name": _vm.expenseForm,
                          "prop-name": "instrument_date"
                        }
                      })
                    ],
                    1
                  )
                ])
              : _vm._e(),
            _vm._v(" "),
            _vm.getPaymentMethodDetail("instrument_bank_detail")
              ? _c("div", { staticClass: "col-12 col-sm-3" }, [
                  _c(
                    "div",
                    { staticClass: "form-group" },
                    [
                      _c("label", { attrs: { for: "" } }, [
                        _vm._v(
                          _vm._s(_vm.trans("finance.instrument_bank_detail"))
                        )
                      ]),
                      _vm._v(" "),
                      _c("input", {
                        directives: [
                          {
                            name: "model",
                            rawName: "v-model",
                            value: _vm.expenseForm.instrument_bank_detail,
                            expression: "expenseForm.instrument_bank_detail"
                          }
                        ],
                        staticClass: "form-control",
                        attrs: {
                          type: "text",
                          name: "instrument_bank_detail",
                          placeholder: _vm.trans(
                            "finance.instrument_bank_detail"
                          )
                        },
                        domProps: {
                          value: _vm.expenseForm.instrument_bank_detail
                        },
                        on: {
                          input: function($event) {
                            if ($event.target.composing) {
                              return
                            }
                            _vm.$set(
                              _vm.expenseForm,
                              "instrument_bank_detail",
                              $event.target.value
                            )
                          }
                        }
                      }),
                      _vm._v(" "),
                      _c("show-error", {
                        attrs: {
                          "form-name": _vm.expenseForm,
                          "prop-name": "instrument_bank_detail"
                        }
                      })
                    ],
                    1
                  )
                ])
              : _vm._e(),
            _vm._v(" "),
            _vm.getPaymentMethodDetail("instrument_clearing_date")
              ? _c("div", { staticClass: "col-12 col-sm-3" }, [
                  _c(
                    "div",
                    { staticClass: "form-group" },
                    [
                      _c("label", { attrs: { for: "" } }, [
                        _vm._v(
                          _vm._s(_vm.trans("finance.instrument_clearing_date"))
                        )
                      ]),
                      _vm._v(" "),
                      _c("datepicker", {
                        attrs: {
                          bootstrapStyling: true,
                          placeholder: _vm.trans(
                            "finance.instrument_clearing_date"
                          )
                        },
                        on: {
                          selected: function($event) {
                            return _vm.expenseForm.errors.clear(
                              "instrument_clearing_date"
                            )
                          }
                        },
                        model: {
                          value: _vm.expenseForm.instrument_clearing_date,
                          callback: function($$v) {
                            _vm.$set(
                              _vm.expenseForm,
                              "instrument_clearing_date",
                              $$v
                            )
                          },
                          expression: "expenseForm.instrument_clearing_date"
                        }
                      }),
                      _vm._v(" "),
                      _c("show-error", {
                        attrs: {
                          "form-name": _vm.expenseForm,
                          "prop-name": "instrument_clearing_date"
                        }
                      })
                    ],
                    1
                  )
                ])
              : _vm._e(),
            _vm._v(" "),
            _vm.getPaymentMethodDetail("reference_number")
              ? _c("div", { staticClass: "col-12 col-sm-3" }, [
                  _c(
                    "div",
                    { staticClass: "form-group" },
                    [
                      _c("label", { attrs: { for: "" } }, [
                        _vm._v(_vm._s(_vm.trans("finance.reference_number")))
                      ]),
                      _vm._v(" "),
                      _c("input", {
                        directives: [
                          {
                            name: "model",
                            rawName: "v-model",
                            value: _vm.expenseForm.reference_number,
                            expression: "expenseForm.reference_number"
                          }
                        ],
                        staticClass: "form-control",
                        attrs: {
                          type: "text",
                          name: "reference_number",
                          placeholder: _vm.trans("finance.reference_number")
                        },
                        domProps: { value: _vm.expenseForm.reference_number },
                        on: {
                          input: function($event) {
                            if ($event.target.composing) {
                              return
                            }
                            _vm.$set(
                              _vm.expenseForm,
                              "reference_number",
                              $event.target.value
                            )
                          }
                        }
                      }),
                      _vm._v(" "),
                      _c("show-error", {
                        attrs: {
                          "form-name": _vm.expenseForm,
                          "prop-name": "reference_number"
                        }
                      })
                    ],
                    1
                  )
                ])
              : _vm._e(),
            _vm._v(" "),
            _c("div", { staticClass: "col-12 col-sm-9" }, [
              _c(
                "div",
                { staticClass: "form-group" },
                [
                  _c("label", { attrs: { for: "" } }, [
                    _vm._v(_vm._s(_vm.trans("finance.expense_description")))
                  ]),
                  _vm._v(" "),
                  _c("autosize-textarea", {
                    attrs: {
                      rows: "1",
                      name: "description",
                      placeholder: _vm.trans("finance.expense_description")
                    },
                    model: {
                      value: _vm.expenseForm.description,
                      callback: function($$v) {
                        _vm.$set(_vm.expenseForm, "description", $$v)
                      },
                      expression: "expenseForm.description"
                    }
                  }),
                  _vm._v(" "),
                  _c("show-error", {
                    attrs: {
                      "form-name": _vm.expenseForm,
                      "prop-name": "description"
                    }
                  })
                ],
                1
              )
            ]),
            _vm._v(" "),
            _c("div", { staticClass: "col-12" }, [
              _c(
                "div",
                { staticClass: "form-group" },
                [
                  _c("file-upload-input", {
                    attrs: {
                      "button-text": _vm.trans("general.upload_document"),
                      token: _vm.expenseForm.upload_token,
                      module: "expense",
                      "clear-file": _vm.clearAttachment,
                      "module-id": _vm.module_id
                    }
                  })
                ],
                1
              )
            ])
          ]),
          _vm._v(" "),
          _c(
            "div",
            { staticClass: "card-footer text-right" },
            [
              _c(
                "router-link",
                {
                  directives: [
                    {
                      name: "show",
                      rawName: "v-show",
                      value: _vm.uuid,
                      expression: "uuid"
                    }
                  ],
                  staticClass: "btn btn-danger waves-effect waves-light ",
                  attrs: { to: "/finance/transaction/expense" }
                },
                [_vm._v(_vm._s(_vm.trans("general.cancel")))]
              ),
              _vm._v(" "),
              !_vm.uuid
                ? _c(
                    "button",
                    {
                      staticClass: "btn btn-danger waves-effect waves-light ",
                      attrs: { type: "button" },
                      on: {
                        click: function($event) {
                          return _vm.$emit("cancel")
                        }
                      }
                    },
                    [_vm._v(_vm._s(_vm.trans("general.cancel")))]
                  )
                : _vm._e(),
              _vm._v(" "),
              _c(
                "button",
                {
                  staticClass: "btn btn-info waves-effect waves-light",
                  attrs: { type: "submit" }
                },
                [
                  _vm.uuid
                    ? _c("span", [_vm._v(_vm._s(_vm.trans("general.update")))])
                    : _c("span", [_vm._v(_vm._s(_vm.trans("general.save")))])
                ]
              )
            ],
            1
          )
        ]
      ),
      _vm._v(" "),
      _vm.showTransactionCategoryModal
        ? _c("transition", { attrs: { name: "modal" } }, [
            _c("div", { staticClass: "modal-mask" }, [
              _c("div", { staticClass: "modal-wrapper" }, [
                _c("div", { staticClass: "modal-container modal-lg" }, [
                  _c(
                    "div",
                    { staticClass: "modal-header" },
                    [
                      _vm._t("header", [
                        _vm._v(
                          "\n                                " +
                            _vm._s(
                              _vm.trans("finance.add_new_transaction_category")
                            ) +
                            "\n                                "
                        ),
                        _c(
                          "span",
                          {
                            staticClass: "float-right pointer",
                            on: {
                              click: function($event) {
                                _vm.showTransactionCategoryModal = false
                              }
                            }
                          },
                          [_vm._v("x")]
                        )
                      ])
                    ],
                    2
                  ),
                  _vm._v(" "),
                  _c(
                    "div",
                    { staticClass: "modal-body" },
                    [
                      _vm._t("body", [
                        _c("transaction-category-form", {
                          on: {
                            completed: _vm.getPreRequisite,
                            cancel: function($event) {
                              _vm.showTransactionCategoryModal = false
                            }
                          }
                        }),
                        _vm._v(" "),
                        _c("div", { staticClass: "clearfix" })
                      ])
                    ],
                    2
                  )
                ])
              ])
            ])
          ])
        : _vm._e()
    ],
    1
  )
}
var staticRenderFns = []
render._withStripped = true



/***/ }),

/***/ "./resources/js/views/finance/transaction/expense/form.vue":
/*!*****************************************************************!*\
  !*** ./resources/js/views/finance/transaction/expense/form.vue ***!
  \*****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _form_vue_vue_type_template_id_bd3aba80___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./form.vue?vue&type=template&id=bd3aba80& */ "./resources/js/views/finance/transaction/expense/form.vue?vue&type=template&id=bd3aba80&");
/* harmony import */ var _form_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form.vue?vue&type=script&lang=js& */ "./resources/js/views/finance/transaction/expense/form.vue?vue&type=script&lang=js&");
/* empty/unused harmony star reexport *//* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ "./node_modules/vue-loader/lib/runtime/componentNormalizer.js");





/* normalize component */

var component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(
  _form_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__["default"],
  _form_vue_vue_type_template_id_bd3aba80___WEBPACK_IMPORTED_MODULE_0__["render"],
  _form_vue_vue_type_template_id_bd3aba80___WEBPACK_IMPORTED_MODULE_0__["staticRenderFns"],
  false,
  null,
  null,
  null
  
)

/* hot reload */
if (false) { var api; }
component.options.__file = "resources/js/views/finance/transaction/expense/form.vue"
/* harmony default export */ __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ "./resources/js/views/finance/transaction/expense/form.vue?vue&type=script&lang=js&":
/*!******************************************************************************************!*\
  !*** ./resources/js/views/finance/transaction/expense/form.vue?vue&type=script&lang=js& ***!
  \******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_babel_loader_lib_index_js_ref_4_0_node_modules_vue_loader_lib_index_js_vue_loader_options_form_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib??ref--4-0!../../../../../../node_modules/vue-loader/lib??vue-loader-options!./form.vue?vue&type=script&lang=js& */ "./node_modules/babel-loader/lib/index.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/views/finance/transaction/expense/form.vue?vue&type=script&lang=js&");
/* empty/unused harmony star reexport */ /* harmony default export */ __webpack_exports__["default"] = (_node_modules_babel_loader_lib_index_js_ref_4_0_node_modules_vue_loader_lib_index_js_vue_loader_options_form_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__["default"]); 

/***/ }),

/***/ "./resources/js/views/finance/transaction/expense/form.vue?vue&type=template&id=bd3aba80&":
/*!************************************************************************************************!*\
  !*** ./resources/js/views/finance/transaction/expense/form.vue?vue&type=template&id=bd3aba80& ***!
  \************************************************************************************************/
/*! exports provided: render, staticRenderFns */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_form_vue_vue_type_template_id_bd3aba80___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!../../../../../../node_modules/vue-loader/lib??vue-loader-options!./form.vue?vue&type=template&id=bd3aba80& */ "./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/vue-loader/lib/index.js?!./resources/js/views/finance/transaction/expense/form.vue?vue&type=template&id=bd3aba80&");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "render", function() { return _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_form_vue_vue_type_template_id_bd3aba80___WEBPACK_IMPORTED_MODULE_0__["render"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "staticRenderFns", function() { return _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_form_vue_vue_type_template_id_bd3aba80___WEBPACK_IMPORTED_MODULE_0__["staticRenderFns"]; });



/***/ })

}]);
//# sourceMappingURL=index.js.map?id=593bc3c3238d262c947e